//  ****************************************************************
//  ****************************************************************
//	****														****
//	****	Interruptroutinen fr S65 Digitalanzeige			****
//	****														****
//  ****************************************************************
//  ****************************************************************

//  ****************************************************************
//	****														
//	****	TMR0-Int, wird zyklisch jede ms ausgelst
//	****										
//  ****************************************************************

#Int_Timer0
void Timer0_ISR(void)
{ signed int tp;

  TMR0=TMR0StartValue;

// Timeout fr RS232
  if (_EmpfangAktiv)
  { RSXXX_Timeout++;							// Timeout erhhen, wenn Empfang aktiv
    if (RSXXX_Timeout>MaxRS232_Timeout) 
    { _EmpfangAktiv=false;				
	  _DatenEmpfangen=false;					// warscheinlich Strung, Daten verwerfen
      PEbuff=0;									// Zeiger auf Empfangspufferposition zurcksetzen
	}
  }	

// Zeit fr Tastaturabfrage
  if (TastaturTimer<TastZeit)							
   { TastaturTimer++;
   }
  else
   { _TastAbfrage=True;
	 TastaturTimer=0;
   }

// Zeit fr Messwertabfrage
  if (MessTimer<MessZeit)							
   { MessTimer++;
   }
  else
   { _MesswertAbfrage=True;
	 MessTimer=0;
   }

  AbsTimeOutTimer++;

// Encoder abfragen 
	Tp=0;
	if (_Alt_Enc_A!=Enc_A)						// nderung?
	{ if(Enc_A)										// Steigende Flanke
	    { if (Enc_B) Tp=1; else Tp=-1;}  
	  else											// fallende Flanke
	    { if (Enc_B) Tp=-1; else Tp=1;}
	  _Alt_Enc_A=Enc_A;
      EncValue+=Tp;
    }

}	  

//  ********************************************************************
//	****														
//	****	RDA-Int, wird ausgelst, wenn Zeichen ber UART empfangen
//	****										
//  ********************************************************************

#INT_RDA

void RDA_isr()
{ int temp;

  _EmpfangAktiv=true;
  RSXXX_Timeout=0;									// Timeout zurcksetzen
  if (!FERR)
  { temp=RCReg;
    if (Checkparity(temp)) 
	{ Ebuff[PEbuff]=temp;							// empfangenes Byte in Empfangspuffer
      if ((PEBuff>0)&&(PEBuff==Ebuff[0]))			// alle Datenbytes empfangen?
      { _EmpfangAktiv=false;						// Empfangsroutine beendet
	    _DatenEmpfangen=true;}						// Signalisierung, das Datensatz emfangen
      else // alle Daten empfangen?
      { PEBuff++;									// Empfangspuffer auf nchstes Byte
        if (PEBuff>=EBuffSize)
         PEbuff=0;// bei berlauf zurcksetzen
	  }
    }
  }
  else // Framing Error
  {Temp=RCREG;}										// Byte trotzdem lesen, aber nicht abspeichern
}

//  ********************************************************************
//	****														
//	****	TBE-Int, wird ausgelst, wenn Zeichen gesendet
//	****										
//  ********************************************************************

#INT_TBE

void TBE_isr()
{ PSBuff++;											// auf nchstes Byte
  GetParity(SBuff[PSBuff]);
  TXREG=SBuff[PSBuff];								// nchstes Byte senden
  if (PSBuff>=ZSend-1)								// alle Daten gesendet?
  { Disable_Interrupts(Int_TBE);					// SendeInterrupt sperren
	PSBuff=0;}										// Zeiger auf Pufferanfang
}


